<?php use App\Services\Util; ?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Dashboard - faucet.win</title></head>
<body style="font-family:system-ui;max-width:980px;margin:40px auto;">
<h1>Dashboard</h1>
<p>Logged in as <b><?= Util::esc($user['email']) ?></b></p>
<p>Email verified: <?= empty($user['email_verified_at']) ? '<span style="color:#b00">No (check your email)</span>' : '<span style="color:#090">Yes</span>' ?></p>
<p>Balance: <b><?= Util::esc((string)$user['balance_doge']) ?> DOGE</b></p>
<?php
  $now = new DateTimeImmutable('now');
  $next = $user['next_claim_at'] ? new DateTimeImmutable($user['next_claim_at']) : null;
  $cooldownOk = (!$next) || ($now >= $next);
  $remaining = $next && !$cooldownOk ? max(0, $next->getTimestamp() - $now->getTimestamp()) : 0;
  $mins = intdiv($remaining, 60);
  $secs = $remaining % 60;
?>
<p>Rolls today: <b><?= (int)$countToday ?></b> / <b><?= (int)$maxPerDay ?></b></p>
<p>Cooldown: <?= $cooldownOk ? '<span style="color:#090">Ready</span>' : '<span style="color:#b00">' . $mins . 'm ' . $secs . 's</span>' ?></p>

<h2>Roll 1–100</h2>
<form method="post" action="/claim" style="display:grid;gap:12px;max-width:520px;">
  <input type="hidden" name="csrf" value="<?= Util::esc($csrf) ?>">
  <?php if (!empty($turnstile_sitekey)): ?>
    <div class="cf-turnstile" data-sitekey="<?= Util::esc($turnstile_sitekey) ?>"></div>
    <script src="https://challenges.cloudflare.com/turnstile/v0/api.js" async defer></script>
  <?php endif; ?>
  <button type="submit" style="padding:14px;font-size:16px;" <?= $cooldownOk ? '' : 'disabled' ?>>Roll Dice</button>
</form>

<form method="post" action="/logout" style="margin-top:18px;">
  <input type="hidden" name="csrf" value="<?= Util::esc($csrf) ?>">
  <button type="submit">Logout</button>
</form>

<h2>Recent rolls</h2>
<table border="1" cellpadding="8" cellspacing="0">
<tr><th>When</th><th>Roll</th><th>Reward (DOGE)</th></tr>
<?php foreach (($claims ?? []) as $c): ?>
<tr>
  <td><?= Util::esc((string)$c['created_at']) ?></td>
  <td><?= (int)$c['rolled'] ?></td>
  <td><?= Util::esc((string)$c['reward_doge']) ?></td>
</tr>
<?php endforeach; ?>
</table>

<p style="margin-top:30px;color:#666;">Rule defaults: 1 roll every <?= (int)$interval ?> minutes, max <?= (int)$maxPerDay ?> per day. Admin can change these.</p>
</body></html>
