<?php use App\Services\Util; ?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Users</title></head>
<body style="font-family:system-ui;max-width:1100px;margin:40px auto;">
<h1>Users</h1>
<nav style="display:flex;gap:12px;">
  <a href="/admin">Dashboard</a>
  <a href="/admin/settings">Settings</a>
</nav>
<form method="get" action="/admin/users" style="margin:18px 0;display:flex;gap:8px;">
  <input name="q" value="<?= Util::esc((string)$q) ?>" placeholder="Search email" style="padding:10px;flex:1;">
  <button type="submit">Search</button>
</form>
<table border="1" cellpadding="8" cellspacing="0" style="width:100%;">
<tr><th>ID</th><th>Email</th><th>Role</th><th>Status</th><th>Verified</th><th>Balance</th><th>Next claim</th><th>Created</th></tr>
<?php foreach (($users ?? []) as $u): ?>
<tr>
  <td><?= (int)$u['id'] ?></td>
  <td><?= Util::esc((string)$u['email']) ?></td>
  <td><?= Util::esc((string)$u['role']) ?></td>
  <td><?= Util::esc((string)$u['status']) ?></td>
  <td><?= empty($u['email_verified_at']) ? 'no' : 'yes' ?></td>
  <td><?= Util::esc((string)$u['balance_doge']) ?></td>
  <td><?= Util::esc((string)($u['next_claim_at'] ?? '')) ?></td>
  <td><?= Util::esc((string)$u['created_at']) ?></td>
</tr>
<?php endforeach; ?>
</table>
</body></html>
