<?php use App\Services\Util; 
$payout = $settings['payout_table_json'] ?? [
  ['min'=>1,'max'=>5,'reward'=>'0.50'],
  ['min'=>6,'max'=>20,'reward'=>'0.15'],
  ['min'=>21,'max'=>60,'reward'=>'0.05'],
  ['min'=>61,'max'=>100,'reward'=>'0.01'],
];
$payoutJson = json_encode($payout, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Settings</title></head>
<body style="font-family:system-ui;max-width:980px;margin:40px auto;">
<h1>Settings</h1>
<nav style="display:flex;gap:12px;">
  <a href="/admin">Dashboard</a>
  <a href="/admin/users">Users</a>
</nav>
<form method="post" action="/admin/settings" style="display:grid;gap:12px;margin-top:18px;">
  <input type="hidden" name="csrf" value="<?= Util::esc($csrf) ?>">
  <label>Site name<br><input name="site_name" value="<?= Util::esc((string)($settings['site_name'] ?? 'faucet.win')) ?>" style="width:100%;padding:10px;"></label>
  <label>Site base URL (for email links)<br><input name="site_base_url" value="<?= Util::esc((string)($settings['site_base_url'] ?? '')) ?>" placeholder="https://faucet.win" style="width:100%;padding:10px;"></label>

  <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:12px;">
    <label>Claim interval minutes<br><input name="claim_interval_minutes" value="<?= Util::esc((string)($settings['claim_interval_minutes'] ?? '15')) ?>" style="width:100%;padding:10px;"></label>
    <label>Max claims per day<br><input name="max_claims_per_day" value="<?= Util::esc((string)($settings['max_claims_per_day'] ?? '5')) ?>" style="width:100%;padding:10px;"></label>
  </div>

  <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:12px;">
    <label>Daily user cap DOGE (0=off)<br><input name="daily_user_cap_doge" value="<?= Util::esc((string)($settings['daily_user_cap_doge'] ?? '0')) ?>" style="width:100%;padding:10px;"></label>
    <label>Daily site cap DOGE (0=off)<br><input name="daily_site_cap_doge" value="<?= Util::esc((string)($settings['daily_site_cap_doge'] ?? '0')) ?>" style="width:100%;padding:10px;"></label>
  </div>

  <label>Payout table JSON (1–100)<br>
    <textarea name="payout_table_json" rows="12" style="width:100%;padding:10px;font-family:ui-monospace,monospace;"><?= Util::esc($payoutJson) ?></textarea>
  </label>

  <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:12px;">
    <label>Maintenance mode (0/1)<br><input name="maintenance_mode" value="<?= Util::esc((string)($settings['maintenance_mode'] ?? '0')) ?>" style="width:100%;padding:10px;"></label>
    <label>Maintenance message<br><input name="maintenance_message" value="<?= Util::esc((string)($settings['maintenance_message'] ?? '')) ?>" style="width:100%;padding:10px;"></label>
  </div>

  <button type="submit" style="padding:14px;">Save settings</button>
</form>
<p style="color:#666;margin-top:16px;">Note: Turnstile keys are stored in config/config.php created during install.</p>
</body></html>
