<?php
declare(strict_types=1);

namespace App\Services;

final class RateLimiter
{
    /**
     * Hit a rate limit bucket.
     * Returns true if allowed, false if blocked.
     */
    public static function hit(string $bucket, int $limit, int $windowSeconds): bool
    {
        $pdo = DB::pdo();
        $now = time();
        $appKey = (string)Config::get('app_key', '');
        $key = hash('sha256', $appKey . '|' . $bucket);

        $pdo->beginTransaction();
        $stmt = $pdo->prepare('SELECT window_start, count FROM rate_limits WHERE `key` = :k FOR UPDATE');
        $stmt->execute([':k' => $key]);
        $row = $stmt->fetch();

        if (!$row) {
            $ins = $pdo->prepare('INSERT INTO rate_limits(`key`, window_start, count) VALUES(:k,:ws,1)');
            $ins->execute([':k' => $key, ':ws' => $now]);
            $pdo->commit();
            return true;
        }

        $ws = (int)$row['window_start'];
        $cnt = (int)$row['count'];

        if ($now - $ws >= $windowSeconds) {
            $upd = $pdo->prepare('UPDATE rate_limits SET window_start=:ws, count=1 WHERE `key`=:k');
            $upd->execute([':ws' => $now, ':k' => $key]);
            $pdo->commit();
            return true;
        }

        if ($cnt >= $limit) {
            $pdo->commit();
            return false;
        }

        $upd = $pdo->prepare('UPDATE rate_limits SET count=count+1 WHERE `key`=:k');
        $upd->execute([':k' => $key]);
        $pdo->commit();
        return true;
    }
}
