<?php
declare(strict_types=1);

namespace App\Models;

use App\Services\DB;

final class User
{
    public static function findByEmail(string $email): ?array
    {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare('SELECT * FROM users WHERE email = :e LIMIT 1');
        $stmt->execute([':e'=>$email]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public static function findById(int $id): ?array
    {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare('SELECT * FROM users WHERE id = :id LIMIT 1');
        $stmt->execute([':id'=>$id]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public static function create(string $email, string $passwordHash): int
    {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare('INSERT INTO users(email, password_hash, role, status, created_at, updated_at) VALUES(:e,:p,\'user\',\'active\',NOW(),NOW())');
        $stmt->execute([':e'=>$email, ':p'=>$passwordHash]);
        return (int)$pdo->lastInsertId();
    }

    public static function markVerified(int $userId): void
    {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare('UPDATE users SET email_verified_at = NOW(), updated_at=NOW() WHERE id = :id');
        $stmt->execute([':id'=>$userId]);
    }

    public static function updateLoginMeta(int $userId, ?string $ipHash, ?string $uaHash): void
    {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare('UPDATE users SET last_login_at = NOW(), updated_at=NOW() WHERE id=:id');
        $stmt->execute([':id'=>$userId]);

        $stmt2 = $pdo->prepare('INSERT INTO user_security(user_id,last_ip_hash,last_ua_hash,last_device_cookie_hash,risk_score,failed_login_count,locked_until)
            VALUES(:uid,:ip,:ua,:dc,0,0,NULL)
            ON DUPLICATE KEY UPDATE last_ip_hash=VALUES(last_ip_hash), last_ua_hash=VALUES(last_ua_hash), last_device_cookie_hash=VALUES(last_device_cookie_hash)');
        $stmt2->execute([
            ':uid'=>$userId,
            ':ip'=>$ipHash,
            ':ua'=>$uaHash,
            ':dc'=>null,
        ]);
    }

    public static function setNextClaimAt(int $userId, string $nextClaimAt): void
    {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare('UPDATE users SET next_claim_at = :n WHERE id=:id');
        $stmt->execute([':n'=>$nextClaimAt, ':id'=>$userId]);
    }

    public static function addBalance(int $userId, string $amount): void
    {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare('UPDATE users SET balance_doge = balance_doge + :a WHERE id = :id');
        $stmt->execute([':a'=>$amount, ':id'=>$userId]);
    }
}
