<?php
declare(strict_types=1);

namespace App\Models;

use App\Services\DB;

final class Setting
{
    public static function get(string $key, $default=null)
    {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare('SELECT value FROM settings WHERE `key`=:k LIMIT 1');
        $stmt->execute([':k'=>$key]);
        $row = $stmt->fetch();
        if (!$row) return $default;
        $val = $row['value'];
        $json = json_decode($val, true);
        return (json_last_error()===JSON_ERROR_NONE) ? $json : $val;
    }

    public static function set(string $key, $value): void
    {
        $pdo = DB::pdo();
        if (is_array($value) || is_object($value)) {
            $value = json_encode($value, JSON_UNESCAPED_SLASHES);
        }
        $stmt = $pdo->prepare('INSERT INTO settings(`key`,`value`) VALUES(:k,:v) ON DUPLICATE KEY UPDATE value=VALUES(value)');
        $stmt->execute([':k'=>$key, ':v'=>(string)$value]);
    }

    public static function all(): array
    {
        $pdo = DB::pdo();
        $rows = $pdo->query('SELECT `key`, `value` FROM settings')->fetchAll();
        $out = [];
        foreach ($rows as $r) {
            $k = $r['key'];
            $v = $r['value'];
            $json = json_decode($v, true);
            $out[$k] = (json_last_error()===JSON_ERROR_NONE) ? $json : $v;
        }
        return $out;
    }
}
