<?php
declare(strict_types=1);

namespace App\Models;

use App\Services\DB;

final class Claim
{
    public static function countToday(int $userId, string $date): int
    {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare('SELECT COUNT(*) AS c FROM claims WHERE user_id=:u AND claim_date=:d');
        $stmt->execute([':u'=>$userId, ':d'=>$date]);
        $row = $stmt->fetch();
        return (int)($row['c'] ?? 0);
    }

    public static function insert(int $userId, int $rolled, string $reward, string $ipHash): void
    {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare('INSERT INTO claims(user_id, rolled, reward_doge, claim_date, ip_hash, created_at) VALUES(:u,:r,:rew,CURDATE(),:ip,NOW())');
        $stmt->execute([':u'=>$userId, ':r'=>$rolled, ':rew'=>$reward, ':ip'=>$ipHash]);
    }

    public static function latestForUser(int $userId, int $limit=20): array
    {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare('SELECT rolled, reward_doge, created_at FROM claims WHERE user_id=:u ORDER BY id DESC LIMIT :l');
        $stmt->bindValue(':u',$userId,\PDO::PARAM_INT);
        $stmt->bindValue(':l',$limit,\PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll();
    }
}
