<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Models\Claim;
use App\Models\Setting;
use App\Services\Auth;
use App\Services\CSRF;
use App\Services\View;

final class UserController
{
    public function dashboard(): void
    {
        $u = Auth::requireUser();
        $today = date('Y-m-d');
        $countToday = Claim::countToday((int)$u['id'], $today);
        $maxPerDay = (int)Setting::get('max_claims_per_day', 5);
        $interval = (int)Setting::get('claim_interval_minutes', 15);

        View::render('user/dashboard', [
            'user' => $u,
            'csrf' => CSRF::token(),
            'countToday' => $countToday,
            'maxPerDay' => $maxPerDay,
            'interval' => $interval,
            'turnstile_sitekey' => (string)\App\Services\Config::get('turnstile_sitekey',''),
            'claims' => Claim::latestForUser((int)$u['id'], 15),
        ]);
    }
}
